#pragma once
#ifdef WSHOP_EXPORTS
#define WSHOP_API __declspec(dllexport)
#else
#define WSHOP_API __declspec(dllimport)
#endif
class FString;
struct GetPlayerPoints;
struct AShooterPlayerController;
struct AShooterCharacter;
struct AController;
namespace WShop
{
	/* Returns the amount of points owned by <eosid> */
	WSHOP_API int GetPlayerPoints(const FString& eosid);

	/* Returns the amount of points owned by <AController> */
	WSHOP_API int GetPlayerPoints(AController* player);

	/* Returns the amount of points owned by <player controller> */
	WSHOP_API int GetPlayerPoints(AShooterPlayerController* player);

	/* Returns the amount of points owned by <player character> */
	WSHOP_API int GetPlayerPoints(AShooterCharacter* player_character);



	/* Spends <amount> of players points. Returns true if success, false if there's not enough hexagons or if player was not found. */
	WSHOP_API bool SpendPlayersPoints(const FString& eosid, const int& amount);

	/* Spends <amount> of players points. Returns true if success, false if there's not enough hexagons or if player was not found. */
	WSHOP_API bool SpendPlayersPoints(AController* player, const int& amount);

	/* Spends <amount> of players points. Returns true if success, false if there's not enough hexagons or if player was not found. */
	WSHOP_API bool SpendPlayersPoints(AShooterPlayerController* player, const int& amount);

	/* Spends <amount> of players points. Returns true if success, false if there's not enough hexagons or if player was not found. */
	WSHOP_API bool SpendPlayersPoints(AShooterCharacter* player_character, const int& amount);



	/* Adds <amount> of points to player. Returns true if success, false if player was not found. */
	WSHOP_API bool AddPointsToPlayer(const FString& eosid, const int& amount);

	/* Adds <amount> of points to player. Returns true if success, false if player was not found. */
	WSHOP_API bool AddPointsToPlayer(AController* player, const int& amount);

	/* Adds <amount> of points to player. Returns true if success, false if player was not found. */
	WSHOP_API bool AddPointsToPlayer(AShooterPlayerController* player, const int& amount);

	/* Adds <amount> of points to player. Returns true if success, false if player was not found. */
	WSHOP_API bool AddPointsToPlayer(AShooterCharacter* player_character, const int& amount);



	/* Set player points count to <new_count>. Returns true if success, false if player was not found. */
	WSHOP_API bool SetPlayerPointsCount(const FString& eosid, const int& new_count);

	/* Set player points count to <new_count>. Returns true if success, false if player was not found. */
	WSHOP_API bool SetPlayerPointsCount(AController* player, const int& new_count);

	/* Set player points count to <new_count>. Returns true if success, false if player was not found. */
	WSHOP_API bool SetPlayerPointsCount(AShooterPlayerController* player, const int& new_count);

	/* Set player points count to <new_count>. Returns true if success, false if player was not found. */
	WSHOP_API bool SetPlayerPointsCount(AShooterCharacter* player_character, const int& new_count);

}